/**
 * \file bricks.h
 *
 * \brief Dclaration de diverses fonctions et macros gnriques de base
 * \author Denis MARTIN
 * \date 2017-2019
 */


/*

Copyright (C) 2017, 2019 Denis MARTIN

---------------------------------------

This file is part of MinD.

MinD is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or any later version.

MinD is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with MinD.  If not, see <http://www.gnu.org/licenses/>.

--------------------------------------------------------------------------

Ce fichier fait partie de MinD.

MinD est un logiciel libre : il peut tre redistribu et/ou modifi
selon les termes de la Licence Publique Gnrale GNU telle que publie par
la Free Software Foundation, soit la version 3 de la licence ou toute
version ultrieure.

MinD est distribu dans l'espoir qu'il sera utile,
mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de
VALEUR MARCHANDE ou d'ADEQUATION AVEC UN BUT PARTICULIER. Voir la
Licence Publique Gnrale GNU pour plus de dtails.

Une copie de la Licence Publique Gnrale GNU devrait tre fournie
avec MinD. Si ce n'est pas le cas, voir <http://www.gnu.org/licenses/>.

*/


#ifndef BRICKS_INCLUDED
#define BRICKS_INCLUDED


#ifdef WIN32
#define s_barre_slash "\\"
#define c_barre_slash '\\'
#else
#define s_barre_slash "/"
#define c_barre_slash '/'
#endif


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef MIND_GTK

#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>

#include <tchar.h>
#include <shlwapi.h>

#include <unistd.h>

#include "resource.h"

#else

#include <ctype.h>
#include <gtk/gtk.h>

#include "mind_gtk.h"

#endif

#define cSeparator ';'
#define sSeparator TEXT(";")

#define MAX_BUFFER 0x2000


_TCHAR *RetrieveValueInString(_TCHAR *text, _TCHAR **textNext);
_TCHAR *LocateKeywordInString(_TCHAR *text, _TCHAR *keyWord, _TCHAR *stringOpen, _TCHAR *stringClose);

_TCHAR *FileInChooser(HWND hwnd, const _TCHAR *title, const _TCHAR *type);
_TCHAR *FileOutChooser(HWND hwnd, const _TCHAR *title, const _TCHAR *type);

HWND AddTooltip(HWND hwnd, const _TCHAR *text);

int MessageBoxYesNo(HWND hwndParent, _TCHAR *message, _TCHAR *title);

#endif // BRICKS_INCLUDED

