/**
 * \file dialog.h
 *
 * \brief Dclaration des fonctions et macros pour la gestion des dialogues
 * \author Denis MARTIN
 * \date 2017-2019
 */


/*

Copyright (C) 2017, 2019 Denis MARTIN

---------------------------------------

This file is part of MinD.

MinD is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or any later version.

MinD is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with MinD.  If not, see <http://www.gnu.org/licenses/>.

--------------------------------------------------------------------------

Ce fichier fait partie de MinD.

MinD est un logiciel libre : il peut tre redistribu et/ou modifi
selon les termes de la Licence Publique Gnrale GNU telle que publie par
la Free Software Foundation, soit la version 3 de la licence ou toute
version ultrieure.

MinD est distribu dans l'espoir qu'il sera utile,
mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de
VALEUR MARCHANDE ou d'ADEQUATION AVEC UN BUT PARTICULIER. Voir la
Licence Publique Gnrale GNU pour plus de dtails.

Une copie de la Licence Publique Gnrale GNU devrait tre fournie
avec MinD. Si ce n'est pas le cas, voir <http://www.gnu.org/licenses/>.

*/


#ifndef DIALOG_INCLUDED
#define DIALOG_INCLUDED

#define MAX_ITEM 100

#include "bricks.h"
#include "variable.h"

#define ITEM_TYPE_MASK      0xF000
#define ITEM_GROUP_MASK     0xFF00
#define ITEM_INDEX_MASK     0x00FF

#define BUTTON_ID           0x1000
#define RADIO_ID            0x3000
#define STATIC_ID           0x5000
#define EDITBOX_ID          0x6000
#define CHECKBOX_ID         0x7000
#define DROPBOX_ID          0x8000


#ifndef MIND_GTK
BOOL CALLBACK MinDDialog_Procedure(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
#else
int MinDDialog_Procedure(HWND hwndParent, _TCHAR *line);
#endif


#endif // DIALOG_INCLUDED

