/**
 * \file message.c
 *
 * \brief Implmentation des fonctions et macros pour la gestion des messages
 * \author Denis MARTIN
 * \date 2017-2019
 */


/*

Copyright (C) 2017, 2019 Denis MARTIN

---------------------------------------

This file is part of MinD.

MinD is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or any later version.

MinD is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with MinD.  If not, see <http://www.gnu.org/licenses/>.

--------------------------------------------------------------------------

Ce fichier fait partie de MinD.

MinD est un logiciel libre : il peut tre redistribu et/ou modifi
selon les termes de la Licence Publique Gnrale GNU telle que publie par
la Free Software Foundation, soit la version 3 de la licence ou toute
version ultrieure.

MinD est distribu dans l'espoir qu'il sera utile,
mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de
VALEUR MARCHANDE ou d'ADEQUATION AVEC UN BUT PARTICULIER. Voir la
Licence Publique Gnrale GNU pour plus de dtails.

Une copie de la Licence Publique Gnrale GNU devrait tre fournie
avec MinD. Si ce n'est pas le cas, voir <http://www.gnu.org/licenses/>.

*/


#include "message.h"


/**
 * \fn _TCHAR *MinDMessage_ExtractString(_TCHAR *text, _TCHAR *keyWord)
 * \brief extrait la chane  afficher de la ligne de commande
 *
 * la fonction parcourt la commande jusqu' rencontrer le mot-clef puis extrait la chane situe derrire
 *
 * \param text : texte de la commande
 * \param keyWord : mot-clef  trouver
 *
 * \return une chane qui doit tre libre par l'appelant
 * \return une chane statique vide "" si le mot-clef est trouv sans argument
 * \return NULL si le mot-clef n'est pas trouv (ou autre problme)
 */
static _TCHAR *MinDMessage_ExtractString(_TCHAR *text, _TCHAR *keyWord)
{
  _TCHAR *result = LocateKeywordInString(text, keyWord, NULL, NULL);

  if (result)
    {
      result = RetrieveValueInString(result, NULL);
    }

  return result;
}


/**
 * \fn int MinDMessage(HINSTANCE hInstance, HWND hwnd, _TCHAR *line)
 * \brief Cration et affichage d'un message d'information
 *
 * \param hInstance : instance de l'application
 * \param hwnd : handle de la fentre parent
 * \param line : ligne de commande
 *
 * \return 0 si tout s'est bien pass
 * \return -1 si le message n'a pas pu tre affich
 */
int MinDMessage(HINSTANCE hInstance, HWND hwnd, _TCHAR *line)
{
  int result = -1;

  _TCHAR *message = MinDMessage_ExtractString(line, TEXT("PAUSE"));
  if (!message)
    {
      message = TEXT("");
    }

  _TCHAR *title = MinDMessage_ExtractString(line, TEXT("TITLE"));
  if (!title)
    {
      title = TEXT("");
    }

  _TCHAR *string = TEXT("(DIALOG TITLE \"\" WIDTH 400 HEIGHT 160)"
                 " (BUTTONSET TITLE \"&OK\" AT 300 120 DEFAULT 1)"
                 " (TEXT TITLE \"\" AT 20 20 WIDTH 340 HEIGHT 80 CENTER)");

  int length = _tcslen(string) + _tcslen(title) + _tcslen(message);
  _TCHAR *command = calloc(sizeof(_TCHAR), length + 1);
  if (command)
    {
      _sntprintf(command, length,
              TEXT(" (DIALOG TITLE \"%s\" WIDTH 400 HEIGHT 160)"
              " (BUTTONSET TITLE \"&OK\" AT 300 120 DEFAULT 1)"
              " (TEXT TITLE \"%s\" AT 20 20 WIDTH 340 HEIGHT 80 CENTER)"),
              title, message);

#ifndef MIND_GTK
      result = DialogBoxParam(hInstance, TEXT("DLG_MinDDialog"), hwnd,
                               (DLGPROC)MinDDialog_Procedure, (LPARAM) command);
#else
      result = MinDDialog_Procedure(hwnd, command);
#endif

      free(command);
    }

  if (message[0])
    {
      free(message);
    }

  if (title[0])
    {
      free(title);
    }

  return result;
}


