/**
 * \file mind_gtk.h
 *
 * \brief Dfinitions et macros gnriques (version GTK)
 *
 * \author Denis MARTIN
 * \date 2017-2019
 *
 */


/*

Copyright (C) 2017, 2019 Denis MARTIN

---------------------------------------

This file is part of MinD.

MinD is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or any later version.

MinD is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with MinD.  If not, see <http://www.gnu.org/licenses/>.

--------------------------------------------------------------------------

Ce fichier fait partie de MinD.

MinD est un logiciel libre : il peut tre redistribu et/ou modifi
selon les termes de la Licence Publique Gnrale GNU telle que publie par
la Free Software Foundation, soit la version 3 de la licence ou toute
version ultrieure.

MinD est distribu dans l'espoir qu'il sera utile,
mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de
VALEUR MARCHANDE ou d'ADEQUATION AVEC UN BUT PARTICULIER. Voir la
Licence Publique Gnrale GNU pour plus de dtails.

Une copie de la Licence Publique Gnrale GNU devrait tre fournie
avec MinD. Si ce n'est pas le cas, voir <http://www.gnu.org/licenses/>.

*/


#ifndef H_MIND_GTK_INCLUDED
#define H_MIND_GTK_INCLUDED


#define HWND GtkWidget*
#define HINSTANCE GtkWidget*
#define MAX_PATH PATH_MAX
#define LPARAM void*
#define WPARAM void*
#define UINT uint

#define EndDialog(a,b) gtk_dialog_response(GTK_DIALOG(a),b)

#define SetWindowText(hwnd,title) gtk_window_set_title(GTK_WINDOW(hwnd),title)

#define _TCHAR char
#define TEXT(a) a
#define LONG_PTR int

#define _totupper toupper

#define _istspace isspace
#define _istalnum isalnum

#define _tcslen strlen
#define _tcsdup strdup
#define _tcscmp strcmp
#define _tcsicmp strcasecmp
#define _tcsnicmp strncasecmp
#define _tcstol strtol
#define _tcscpy strcpy
#define _tcsncpy strncpy
#define _tcschr strchr
#define _tcsrchr strrchr
#define _tcscat strcat
#define _tcsspn strspn
#define _tcscspn strcspn

#define _tfopen fopen
#define _fgetts fgets
#define _ftprintf fprintf

#define _sntprintf snprintf


#ifndef BOOL
#define BOOL int
#endif


#ifndef IDYES
#define IDNO 0
#define IDYES 1
#endif


typedef struct {int id; GtkWidget *hwnd;} DATA;

typedef struct {int x; int y;} POINT;


// variables globales ( supprimer  terme)
GtkWidget *clientZone;


#endif
